/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nways.cfgman;

import com.ibm.nways.cfgman.CfgManException;
import com.ibm.nways.cfgman.CfgManService;
import com.ibm.nways.cfgman.DbManager;
import com.ibm.nways.cfgman.DbObject;
import com.ibm.nways.cfgman.DevCfgDataSource;
import java.sql.SQLException;
import java.sql.Timestamp;
import jclass.table3.TableData;

class DevCfg
extends DbObject {
    int version;
    int deviceId;
    String address;
    String versionStatus;
    String approvalStatus;
    String commitStatus;
    String remarks;
    String modifiedBy;
    Timestamp modifiedAt;
    static final String Incomplete = "incomplete";
    static final String Inactive = "inactive";
    static final String Active = "active";
    static final String Nascent = "nascent";
    static final String Obsolescent = "obsolescent";
    static final String Uncommited = "uncommited";
    static final String Commited = "commited";
    static final String Approved = "approved";
    static final String Unapproved = "unapproved";
    static final String Rejected = "rejected";
    static final String None = "none";

    public DevCfg() {
    }

    public DevCfg(CfgManService cfgManService) {
        super(cfgManService);
    }

    public void insert(boolean bl) throws SQLException {
        this.dbManager.devCfgTable.add(this);
        if (bl) {
            this.cxn.commit();
        }
    }

    public boolean get(boolean bl) throws SQLException {
        boolean bl2 = this.dbManager.devCfgTable.get(this);
        if (bl) {
            this.cxn.commit();
        }
        return bl2;
    }

    public int getCount(boolean bl) throws SQLException {
        int n = this.dbManager.devCfgTable.getCount(this);
        if (bl) {
            this.cxn.commit();
        }
        return n;
    }

    public boolean getActiveVersion(boolean bl) throws SQLException {
        boolean bl2 = this.dbManager.devCfgTable.getActiveVersion(this);
        if (bl) {
            this.cxn.commit();
        }
        return bl2;
    }

    public int update(boolean bl) throws SQLException {
        int n = this.dbManager.devCfgTable.update(this);
        if (bl) {
            this.cxn.commit();
        }
        return n;
    }

    public int delete(boolean bl) throws SQLException {
        int n = this.dbManager.devCfgTable.delete(this);
        if (bl) {
            this.cxn.commit();
        }
        return n;
    }

    public int modify(boolean bl, String string) throws SQLException, CfgManException {
        if (this.commitStatus.equals(Commited)) {
            throw new CfgManException(0);
        }
        this.setModification(string);
        this.setVersionStatus();
        return this.update(bl);
    }

    public int setNextVersion(boolean bl) throws SQLException {
        this.version = this.dbManager.deviceTable.nextVersion(this.deviceId, bl);
        return this.version;
    }

    public void setModification(String string) {
        this.modifiedBy = string;
        this.modifiedAt = new Timestamp(System.currentTimeMillis());
    }

    public void setVersionStatus() {
        boolean bl = false;
        if (this.versionStatus != null && this.versionStatus.equals(Active)) {
            bl = true;
        }
        if (this.isCompleteConfig()) {
            if (!(bl || this.versionStatus.equals(Nascent) || this.versionStatus.equals(Obsolescent))) {
                this.versionStatus = Inactive;
                return;
            }
        } else {
            this.versionStatus = Incomplete;
        }
    }

    public boolean isCompleteConfig() {
        return true;
    }

    public boolean isCommited() {
        boolean bl = false;
        if (this.commitStatus != null && this.commitStatus.equals(Commited)) {
            bl = true;
        }
        return bl;
    }

    public void commit(boolean bl) throws CfgManException, SQLException {
        Object object = DbManager.LOCK;
        synchronized (object) {
            boolean bl2 = this.testAndSetAutoCommit(false);
            try {
                try {
                    this.get(false);
                    if (this.versionStatus.equals(Incomplete)) {
                        throw new CfgManException(1, "Cannot commit incomplete version " + this.version + " of device id " + this.deviceId);
                    }
                    this.commitStatus = Commited;
                    this.update(false);
                    if (bl) {
                        this.cxn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        this.cxn.rollback();
                    }
                    throw sQLException;
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.cxn.setAutoCommit(bl2);
                throw throwable;
            }
            this.cxn.setAutoCommit(bl2);
            return;
        }
    }

    public void approve(boolean bl, boolean bl2) throws SQLException {
        Object object = DbManager.LOCK;
        synchronized (object) {
            boolean bl3 = this.testAndSetAutoCommit(false);
            try {
                try {
                    this.get(false);
                    this.approvalStatus = bl2 ? Approved : Rejected;
                    this.update(false);
                    if (bl) {
                        this.cxn.commit();
                    }
                }
                catch (SQLException sQLException) {
                    if (bl) {
                        this.cxn.rollback();
                    }
                    throw sQLException;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.cxn.setAutoCommit(bl3);
                throw throwable;
            }
            this.cxn.setAutoCommit(bl3);
            return;
        }
    }

    public TableData getDataSource() {
        return new DevCfgDataSource(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof DevCfg) {
            DevCfg devCfg = (DevCfg)object;
            bl = this.deviceId == devCfg.deviceId && this.version == devCfg.version;
        }
        return bl;
    }

    public int hashCode() {
        return this.deviceId * 1000 + this.version;
    }

    public String toString() {
        return "[" + this.toString2() + "]";
    }

    protected String toString2() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.version).append(", ").append(this.deviceId).append(", ").append(this.address).append(", ").append(this.versionStatus).append(", ").append(this.approvalStatus).append(", ").append(this.commitStatus).append(", ").append(this.remarks).append(", ").append(this.modifiedBy).append(", ").append(this.modifiedAt);
        return stringBuffer.toString();
    }
}

